/*************************************************************************

   Tiny Self Syntatical Analysis - (C) Jecel 23/08/93

*************************************************************************/

#define PARSER_BODY
#include "parser.h"
#include "lex.h"
#include "scan.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "assert.h"
#include "gc.h"

static char rcsid[] = "$Id: parser.c,v 1.9 1995/11/30 02:02:31 root Exp $";

#define TEST(ep) ASSERT(ep!=NULL,"invalid expression")
#define TESTN(ep)

int openPar, openBracket, openCurly;
struct expr * lastResend = NULL;
int tokensSeen = 0;

struct expr * keyMess();
void printList ( struct expr * ex );

struct expr * getExpr()
    {
    lastError = none;
    openPar = 0;
    openBracket = 0;
    openCurly = 0;
    lastResend = NULL;
    tokensSeen = 0;
    return (keyMess());
    }

struct expr * allocExpr ( char * text, enum exprType kind )
    {
    struct expr * ne;
    char * nc;

    ne = GC_malloc(sizeof(struct expr));
    ASSERT(ne!=NULL,"GC_malloc error for new expression");
    ne->type = kind;
    ne->flags = 0;
    nc = GC_malloc(strlen(text)+1);
    ASSERT(nc!=NULL,"GC_malloc error for new string");
    ne->name = nc;
    strcpy(nc,text);
    return ( ne );
    }

void printExpr ( struct expr * ex )
    {

    TEST(ex);
    printf("%s<", exprStr[ex->type]);
    if ( ex->flags & NLR ) printf("*NLR* ");
    switch ( ex->type )
	{
	case number:
	case string:
	case resend:
			printf("\"%s\"",ex->name);
			break;
	case method:
	case block:
			printf("\"%s\"",ex->name);
			printList(ex->info.method.slots);
			printList(ex->info.method.code);
			break;
	case slot:
			printf("\"%s[%04x]\"",ex->name,ex->flags);
			if ( ex->info.slot.value != NULL )
			    printExpr(ex->info.slot.value);
			else
			    printf("*NIL*");
			break;
	case unary:
			printf("\"%s\" ",ex->name);
			printExpr(ex->info.unaryRec);
			break;
	case binary:
			printf("\"%s\" ",ex->name);
			printExpr(ex->info.bin.receiver);
			printExpr(ex->info.bin.arg);
			break;
	case keyWord:
			printf("\"%s\" ",ex->name);
			printExpr(ex->info.key.receiver);
			printList(ex->info.key.argList);
			break;
	case annot:
			printf("\"%s\" ",ex->name);
			printList(ex->info.annot.value);
			break;
	default:
	printf("*** UNKNOWN TYPE ***");
	}
    printf(">");
    }

void printList ( struct expr * ex )
    {
    int first = 1;

    TESTN(ex);
    printf("{");
    while ( ex != NULL )
	{
	if ( ! first ) printf(",");
	first = 0;
	printExpr(ex);
	ex = ex->next;
	}
    printf("}");
    }

struct token * getNextToken()
    {
    struct token * tk;

    ++ tokensSeen;
    tk = nextToken();
    if ( tk->ltype == empty &&
	 ( openPar || openBracket || openCurly ) )
	return ( getNextToken() );
    else
	return ( tk );
    }

void returnToken ( struct token * tk )
    {
    -- tokensSeen;
    backToken(tk);
    }

struct expr * kMess(struct expr * n);
struct expr * argList(struct expr * n);
struct expr * binMess();
struct expr * bList(struct expr * n);
struct expr * bMess(struct expr * n);
struct expr * unaryMess();
struct expr * uMess(struct expr * n);
struct expr * resendExpr();
struct expr * primary();
struct expr * methodExpr();
struct expr * blockExpr();
struct expr * annotation();
struct expr * codeExpr();
struct expr * slotList();
struct expr * sList();
struct expr * annotSlots();
struct expr * annotList();
struct expr * slotExpr();
int privacy();
struct expr * argSlot();
struct expr * dataSlot();
struct expr * bSlot();
struct expr * kSlot();
struct expr * slotName();

struct expr * keyMess()
    {
    struct expr * n, * x;

    if ( (n = binMess() ) != NULL )
	{
	if ( (x = kMess(n) ) != NULL )
            {
            TEST(x);
	    return ( x );
            }
	else
            {
            TEST(n);
	    return ( n );
            }
	}
    else if ( (n = resendExpr() ) != NULL )
        {
        TEST(n);
        x = kMess(n);
        TESTN(x);
	return ( x );
        }
    else
	return ( NULL );
    }

struct expr * nm(struct expr * x)
    {
	 /* strip inside methods */
    TEST(x);
    if ( x->type == method &&
	 x->info.method.slots == NULL &&
	 x->info.method.code != NULL &&
	 (x->info.method.code)->next == NULL )
	{
	-- pStat.objs;
        TEST(x->info.method.code);
	return ( x->info.method.code );
	}
      else
	return ( x );
    }

struct expr * nmr(struct expr * x)
    {
    struct expr * y;

    y = nm(x);
    if ( y->type == unary ||
	 y->type == binary ||
	 y->type == keyWord )
	++ pStat.menSeq;
    return ( y );
    }

struct expr * nma(struct expr * x)
    {
    struct expr * y;

    y = nm(x);
    if ( y->type == unary ||
	 y->type == binary ||
	 y->type == keyWord )
	++ pStat.menPar;
    return ( y );
    }

struct expr * kMess(struct expr * n)
    {
    char ident[500];
    struct token * tk;
    struct expr * firstArg, * lastArg, * ex;
    int args;

    TEST(n);
    tk = getNextToken();
    if ( tk->ltype == smallKey )
	{
	args = 0;
	strcpy(ident,tk->str);
	firstArg = NULL;
	do  {
	    ex = nma(keyMess());
	    if ( ex == NULL )
		{
		lastError = other;
		fprintf ( stderr, "\n** syntax error: missing expression **\n" );
		return ( NULL );
		}
	    if ( firstArg == NULL )
		{
		firstArg = ex;
		lastArg = ex;
		}
	    else
		{
		lastArg->next = ex;
		lastArg = ex;
		}
	    ++ args;
	    tk = getNextToken();
	    if ( tk->ltype == capKey )
		strcat(ident,tk->str);
	    } while ( tk->ltype == capKey );
	returnToken(tk);
	ex = allocExpr(ident,keyWord);
	ex->info.key.receiver = nmr(n);
	ex->info.key.argList = firstArg;
	ex->next = NULL;
	++ pStat.nargs [ args>9 ? 9 : args ];
	return ( ex );
	}
    else
	{
	returnToken(tk);
	return ( NULL );
	}
    }

struct expr * binMess()
    {
    struct expr * n, * x;

    if ( (n = unaryMess() ) != NULL )
	return ( bList(n) );
    else if ( (x = resendExpr() ) != NULL )
	{
	if ( (n = bMess(x) ) != NULL )
	    return ( bList(n) );
	else
	    {
/*	    lastError = other;
	    fprintf ( stderr, "\n** syntax error: missing operator **\n" );
*/	    return ( NULL );
	    }
	}
    else
	return ( NULL );
    }

struct expr * bList(struct expr * n)
    {
    struct expr * x;

    TEST(n);
    if ( (x = bMess(n) ) != NULL )
        {
        TEST(x);
	return ( bList(x) );
        }
    else
	return ( n );
    }

struct expr * bMess(struct expr * n)
    {
    char ident[80];
    struct token * tk;
    struct expr * ex, * arg;

    TEST(n);
    tk = getNextToken();
    if ( tk->ltype == op )
	{
	++ pStat.nargs[1];
	strcpy(ident,tk->str);
	if ( (arg = unaryMess() ) != NULL )
	    {
	    ex = allocExpr(ident,binary);
	    ex->info.bin.receiver = nmr(n);
	    ex->info.bin.arg = nma(arg);
	    ex->next = NULL;
	    return ( ex );
	    }
	else if ((tk = getNextToken())->ltype == smallKey )
	    {
	    returnToken( tk );
	    ex = allocExpr(ident,binary);
	    ex->info.bin.receiver = nmr(n);
	    ex->info.bin.arg = nma(keyMess());
	    ex->next = NULL;
	    return ( ex );
	    }
	else
	    {
	    returnToken( tk );
	    lastError = other;
	    fprintf ( stderr, "\n** syntax error: missing operand **\n" );
	    return ( NULL );
	    }
	}
    else if ( tk->ltype == num &&
	      tk->str[0] == '-' &&
	      n->type != resend )
	{
	strcpy(ident,"-");
	++ pStat.nargs[1];
	arg = allocExpr(&(tk->str[1]),number);
	arg->next = NULL;
	ex = allocExpr(ident,binary);
	ex->info.bin.receiver = nmr(n);
	ex->info.bin.arg = nma(arg);
	ex->next = NULL;
	return ( ex );
	}
    else
	{
	returnToken( tk );
	return ( NULL );
	}
    }

struct expr * unaryMess()
    {
    struct expr * n, * x;

    if ( (n = primary() ) != NULL )
	{
	if ( (x = uMess(n) ) != NULL )
	    return ( x );
	else
	    return ( n );
	}
    else if ( (x = resendExpr() ) != NULL )
	return ( uMess(x) );
    else
	return ( NULL );
    }

struct expr * uMess(struct expr * n)
    {
    char identifier[80];
    struct token * tk;
    struct expr * ex, * a;

    TEST(n);
    tk = getNextToken();
    if ( tk->ltype == ident )
	{
	strcpy(identifier,tk->str);
	ex = allocExpr(identifier,unary);
	ex->info.unaryRec = nmr(n);
	ex->next = NULL;
	++ pStat.nargs[0];
	if ( (a = uMess(ex) ) != NULL )
	    return ( a );
	else
	    return ( ex );
	}
    else
	{
	returnToken( tk );
	return ( NULL );
	}
    }

struct expr * resendExpr()
    {
    struct token * tk;
    struct expr * ex;
    char c;

    if ( lastResend != NULL && tokensSeen == 0 )
	return ( lastResend );
    tk = getNextToken();
    if ( tk->ltype == ident )
	if ( (c = nextChar()) == '.' )
	    if ( (c = nextChar()) != ' ' &&
		 c != '\t' && c != '\n' &&
		 c != '\0' && c != ']' &&
		 c != ')' && c != '[' &&
		 c != '(' && c != '|' )
		{
		backChar(c);
		ex = allocExpr(tk->str,resend);
		ex->flags = SIMPLERESEND;
		if ( strcmp(tk->str,"resend") )
		    ex->flags = DIRECTEDRESEND;
		ex->next = NULL;
		}
	    else
		{
		backChar(c);
		backChar('.');
		returnToken(tk);
		ex = allocExpr("self",resend);
		ex->flags = SELFSEND;
		ex->next = NULL;
		}
	else
	    {
	    backChar(c);
	    returnToken(tk);
	    ex = allocExpr("self",resend);
	    ex->flags = SELFSEND;
	    ex->next = NULL;
	    }
    else
	{
	returnToken(tk);
	ex = allocExpr("self",resend);
	ex->flags = SELFSEND;
	ex->next = NULL;
	}
    lastResend = ex;
    tokensSeen = 0;
    return ( ex );
    }

struct expr * primary()
    {
    struct token * tk;
    struct expr * ex;

    tk = getNextToken();
    if ( tk->ltype == num )
	{
	ex = allocExpr(tk->str,number);
	ex->next = NULL;
	return ( ex );
	}
    else if ( tk->ltype == lstring )
	{
	ex = allocExpr(tk->str,string);
	ex->next = NULL;
	return ( ex );
	}
    returnToken(tk);
    if ( (ex = methodExpr()) != NULL )
	return ( ex );
    else if ( (ex = blockExpr()) != NULL )
	return ( ex );
    else if ( (ex = annotation()) != NULL )
	return ( ex );
    else
	{
/*	lastError = other;
	fprintf ( stderr, "\n** syntax error: missing primary **\n" );
*/	return ( NULL );
	}
    }

int objsSeen = 0;

struct expr * methodExpr()
    {
    char text[20];
    struct token * tk;
    struct expr * ex, * slts;
    int traits;

    tk = getNextToken();
    if ( tk->ltype == delim && !strcmp(tk->str,"(") )
	{
	++ openPar;
	++ pStat.objs;
	sprintf(text,"<%d>", objsSeen++);
	ex = allocExpr(text,method);
	ex->next = NULL;
	ex->info.method.slots = slotList();
	ex->info.method.code = codeExpr();
	tk = getNextToken();
	if ( ex->info.method.slots != NULL )
	    ++ pStat.slottedObjs;
	if ( ex->info.method.code == NULL )
	    {
	    traits = 1;
	    for ( slts = ex->info.method.slots;
		  slts != NULL;
		  slts = slts->next )
		if ( slts->flags & ASSIGNABLE )
		    traits = 0;
	    if ( traits )
		++ pStat.traitsObjs;
	      else
		++ pStat.dataObjs;
	    }
	if ( tk->ltype != delim || strcmp(tk->str,")") )
	    {
	    lastError = other;
	    fprintf ( stderr, "\n** syntax error: missing \")\" **\n" );
	    return ( NULL );
	    }
	else
	    -- openPar;
	return ( ex );
	}
    returnToken(tk);
    return ( NULL );
    }

int lastObjSeen = 0;
char blockModif = 'A';

struct expr * blockExpr()
    {
    char text[20];
    struct token * tk;
    struct expr * ex;

    tk = getNextToken();
    if ( tk->ltype == delim && !strcmp(tk->str,"[") )
	{
	++ openBracket;
	if ( lastObjSeen != objsSeen )
	    {
	    lastObjSeen = objsSeen;
	    blockModif = 'A';
	    }
	sprintf(text,"<%d%c>", lastObjSeen,blockModif++);
	ex = allocExpr(text,block);
	ex->next = NULL;
	ex->info.method.slots = slotList();
	ex->info.method.code = codeExpr();
	tk = getNextToken();
	if ( tk->ltype != delim || strcmp(tk->str,"]") )
	    {
	    lastError = other;
	    fprintf ( stderr, "\n** syntax error: missing \"]\" **\n" );
	    return ( NULL );
	    }
	else
	    -- openBracket;
	return ( ex );
	}
    returnToken(tk);
    return ( NULL );
    }

struct expr * annotation()
    {
    struct token * tk;
    struct expr * ex;

    tk = getNextToken();
    if ( tk->ltype == delim && !strcmp(tk->str,"{") )
	{
        ++ openCurly;
         tk = getNextToken();
	if ( tk->ltype == lstring )
	    ex = allocExpr(tk->str,annot);
	  else
	    {
	    lastError = other;
	    fprintf ( stderr, "\n** syntax error: missing string **\n" );
	    return ( NULL );
	    }
	ex->next = NULL;
	ex->info.annot.value = primary();
	tk = getNextToken();
	if ( tk->ltype != delim || strcmp(tk->str,"}") )
	    {
	    lastError = other;
	    fprintf ( stderr, "\n** syntax error: missing \"}\" **\n" );
	    return ( NULL );
	    }
          else
            -- openCurly;
	return ( ex );
	}
    returnToken(tk);
    return ( NULL );
    }

struct expr * codeExpr()
    {
    struct token * tk;
    struct expr * ex;

    tk = getNextToken();
    if ( !strcmp(tk->str,"^") && tk->ltype == delim )
	if ( (ex = keyMess()) != NULL )
	    {
	    ex->flags |= NLR;
	    tk = getNextToken();
	    if ( strcmp(tk->str,".") || tk->ltype == lstring )
		returnToken(tk);
	    return ( ex );
	    }
	else
	    {
	    lastError = other;
	    fprintf ( stderr, "\n** syntax error: missing expression **\n" );
	    return ( NULL );
	    }
    else
	{
	returnToken(tk);
	if ( (ex = keyMess()) != NULL )
	    {
	    tk = getNextToken();
	    if ( !strcmp(tk->str,".") && tk->ltype != lstring )
		ex->next = codeExpr();
	    else
		returnToken(tk);
	    return ( ex );
	    }
	else
	    return ( NULL );
	}
    }

struct expr * slotList()
    {
    struct token * tk;

    tk = getNextToken();
    if ( tk->ltype == delim && !strcmp(tk->str,"|") )
	return ( sList() );
    else
	{
	returnToken(tk);
	return ( NULL );
	}
    }

struct expr * sList()
    {
    struct token * tk;
    struct expr * ex;

    tk = getNextToken();
    if ( tk->ltype == delim && !strcmp(tk->str,"|") )
	return ( NULL );
    returnToken(tk);
    if ( (ex = annotSlots()) != NULL )
	{
	ex->next = sList();
	return ( ex );
	}
    if ( (ex = slotExpr()) != NULL )
	{
	tk = getNextToken();
	if ( tk->ltype == delim && !strcmp(tk->str,"|") )
	    return ( ex );
	else if ( !strcmp(tk->str,".") && tk->ltype != lstring )
	    {
	    ex->next = sList();
	    return ( ex );
	    }
	else
	    {
	    returnToken(tk);
	    lastError = other;
	    fprintf ( stderr, "\n** syntax error: missing \"|\" or \".\" **\n" );
	    return ( NULL );
	    }
	}
    else
	{
	lastError = other;
	fprintf ( stderr, "\n** syntax error: missing \"|\" **\n" );
	return ( NULL );
	}
    }

struct expr * annotSlots()
    {
    struct token * tk;
    struct expr * ex;

    tk = getNextToken();
    if ( tk->ltype == delim && !strcmp(tk->str,"{") )
	{
	tk = getNextToken();
        if ( tk->ltype == delim && !strcmp(tk->str,"}") )
            {    /* new object annotation syntax */
            tk = getNextToken ();
            if ( strcmp(tk->str,"=") || tk->ltype != op )
                {
                lastError = other;
                fprintf ( stderr, "\n** syntax error: missing = **\n" );
                return ( NULL );
                }
            tk = getNextToken ();
            if ( tk->ltype == lstring )
                ex = allocExpr(tk->str,annot);
              else
                {
                lastError = other;
                fprintf ( stderr, "\n** syntax error: missing string **\n" );
                return ( NULL );
                }
            ex->next = NULL;
            ex->info.annot.value = NULL;
            tk = getNextToken ();
            if ( strcmp(tk->str,".") || tk->ltype == lstring ) /* look for optional "." */
                returnToken ( tk );
            return ( ex );
            }
	if ( tk->ltype == lstring )
	    ex = allocExpr(tk->str,annot);
	  else
	    {
	    lastError = other;
	    fprintf ( stderr, "\n** syntax error: missing string **\n" );
	    return ( NULL );
	    }
	ex->next = NULL;
	ex->info.annot.value = annotList();
	return ( ex );
	}
    else
	{
	returnToken(tk);
	return ( NULL );
	}
    }

struct expr * annotList()
    {
    struct token * tk;
    struct expr * ex;

    tk = getNextToken();
    if ( tk->ltype == delim && !strcmp(tk->str,"}") )
	return ( NULL );
    returnToken(tk);
    if ( (ex = annotSlots()) != NULL )
	{
	ex->next = annotList();
	return ( ex );
	}
    if ( (ex = slotExpr()) != NULL )
	{
	tk = getNextToken();
	if ( tk->ltype == delim && !strcmp(tk->str,"}") )
	    return ( ex );
	else if ( !strcmp(tk->str,".") && tk->ltype != lstring )
	    {
	    ex->next = annotList();
	    return ( ex );
	    }
	else
	    {
	    returnToken(tk);
	    lastError = other;
	    fprintf ( stderr, "\n** syntax error: missing \"}\" or \".\" **\n" );
	    return ( NULL );
	    }
	}
    else
	{
	lastError = other;
	fprintf ( stderr, "\n** syntax error: missing \"}\" **\n" );
	return ( NULL );
	}
    }

struct expr * slotExpr()
    {
    int f;
    struct expr * ex;

    f = privacy();
    if ( (ex = argSlot() ) != NULL )
	++ pStat.argSlots;
    else if ( (ex = dataSlot() ) != NULL )
	{
	if ( ex->flags & ASSIGNABLE )
	    ++ pStat.normalSlots;
	  else
	    ++ pStat.constSlots;
	}
    else if ( (ex = bSlot() ) != NULL )
	++ pStat.constSlots;
    else if ( (ex = kSlot() ) != NULL )
	++ pStat.constSlots;
    else
	return ( NULL );
    ex->flags |= f;
    return ( ex );
    }

int privacy()
    {
    struct token * tk;
    int f;

    f = 0;
    tk = getNextToken();
    if ( !strcmp(tk->str,"^") && tk->ltype != lstring )
	{
	f |= SPRV(PUBLIC) | APRV(PUBLIC);
	tk = getNextToken();
	if ( !strcmp(tk->str,"_") && tk->ltype != lstring )
	    f |= APRV(PRIVATE);
	else
	    returnToken(tk);
	}
    else if ( !strcmp(tk->str,"_") && tk->ltype != lstring )
	{
	f |= SPRV(PRIVATE) | APRV(PRIVATE);
	tk = getNextToken();
	if ( !strcmp(tk->str,"^") && tk->ltype != lstring )
	    f |= APRV(PUBLIC);
	else
	    returnToken(tk);
	}
    else if ( !strcmp(tk->str,"!")  && tk->ltype != lstring )
	f |= SPRV(VM);
    else
	returnToken(tk);
    return ( f );
    }

struct expr * argSlot()
    {
    struct token * tk;
    struct expr * ex;

    tk = getNextToken();
    if ( !strcmp(tk->str,":") && tk->ltype != lstring )
	{
	if ( (ex = slotName() ) != NULL )
	    ex->flags |= ARGUMENT;
	return ( ex );
	}
    else
	{
	returnToken(tk);
	return ( NULL );
	}
    }

struct expr * dataSlot()
    {
    struct token * tk;
    struct expr * ex;

    if ( (ex = slotName() ) != NULL )
	{
	tk = getNextToken();
	if ( !strcmp(tk->str,"<-") && tk->ltype != lstring )
	    {
	    ex->flags |= ASSIGNABLE;
	    ex->info.slot.value = keyMess();
	    }
	else if ( !strcmp(tk->str,"=") && tk->ltype != lstring )
	    ex->info.slot.value = keyMess();
	else
	    {
	    ex->flags |= ASSIGNABLE;
	    returnToken(tk);
	    }
	return ( ex );
	}
    else
	return ( NULL );
    }

struct expr * makeArgSlot ( char * name )
    {
    struct expr * ex;

    ex = allocExpr(name,slot);
    ex->info.slot.value = NULL;
    ex->next = NULL;
    ex->flags |= ARGUMENT;
    return ( ex );
    }

struct expr * bSlot()
    {
    struct token * tk;
    struct expr * ex, * arg, * mthd;

    tk = getNextToken();
    if ( tk->ltype == op )
	{
	ex = allocExpr(tk->str,slot);
	ex->info.slot.value = NULL;
	ex->next = NULL;
	tk = getNextToken();
	if ( !strcmp(tk->str,"=") && tk->ltype != lstring )
	    ex->info.slot.value = methodExpr();
	else
	    {
	    arg = makeArgSlot(tk->str);
	    tk = getNextToken();
	    if ( strcmp(tk->str,"=") || tk->ltype == lstring )
		{
		lastError = other;
		fprintf ( stderr, "\n** syntax error: missing \"=\" **\n" );
		return ( NULL );
		}
	    ex->info.slot.value = mthd = methodExpr();
	    arg->next = mthd->info.method.slots;
	    mthd->info.method.slots = arg;
	    }
	return ( ex );
	}
    else
	{
	returnToken(tk);
	return ( NULL );
	}
    }

struct expr * kSlot()
    {
    struct token * tk;
    struct expr * ex, * arg, * lastArg, * mthd;
    char name [ 500 ];

    tk = getNextToken();
    if ( tk->ltype == smallKey )
	{
	strcpy(name,tk->str);
	tk = getNextToken();
	arg = NULL;
	if ( tk->ltype == ident )
	    {
	    lastArg = arg = makeArgSlot(tk->str);
	    tk = getNextToken();
	    while ( strcmp(tk->str,"=") || tk->ltype == lstring )
		{
		if ( tk->ltype != capKey )
		    {
		    lastError = other;
		    fprintf ( stderr, "\n** syntax error: missing CAPITAL KEYWORD **\n" );
		    return ( NULL );
		    }
		strcat(name,tk->str);
		tk = getNextToken();
		if ( tk->ltype != ident )
		    {
		    lastError = other;
		    fprintf ( stderr, "\n** syntax error: missing IDENTIFICADOR **\n" );
		    return ( NULL );
		    }
		lastArg->next = makeArgSlot(tk->str);
		lastArg = lastArg->next;
		tk = getNextToken();
		}
	    }
	else
	    while ( strcmp(tk->str,"=") || tk->ltype == lstring )
		{
		if ( tk->ltype != capKey )
		    {
		    lastError = other;
		    fprintf ( stderr, "\n** syntax error: missing CAPITAL KEYWORD **\n" );
		    return ( NULL );
		    }
		strcat(name,tk->str);
		tk = getNextToken();
		}
	ex = allocExpr(name,slot);
	ex->info.slot.value = NULL;
	ex->next = NULL;
	ex->info.slot.value = mthd = methodExpr();
	if ( arg != NULL )
	    {
	    lastArg->next = mthd->info.method.slots;
	    mthd->info.method.slots = arg;
	    }
	return ( ex );
	}
    else
	{
	returnToken(tk);
	return ( NULL );
	}
    }

struct expr * slotName()
    {
    struct token * tk;
    struct expr * ex;
    char * cp;

    tk = getNextToken();
    if ( tk->ltype == ident )
	{
	ex = allocExpr(tk->str,slot);
	ex->info.slot.value = NULL;
	ex->next = NULL;
	tk = getNextToken();
	cp = tk->str;
	while ( *cp && *cp == '*' ) ++cp;
	if ( *cp )
	    returnToken(tk);
	else
	    ex->flags |= PPRI(cp-tk->str);
	return ( ex );
	}
    else
	{
	returnToken(tk);
	return ( NULL );
	}
    }
