/*************************************************************

   MapMap is the meta-space for all meta-space ( map )
   objects. The other maps are:

       slotMap - most self objects ( including the empty
                  object )
       intMap - small integers
       floatMap - floating point numbers
       vectorMap - all kinds of vectorish objects
       byteVectorMap - objects with a pure binary part
       systemMap - ( not used yet ) meta-objects in general
       driverMap - ( not used yet ) drivers for hardware

                    $Id: maps.h,v 1.2 1995/11/30 02:02:07 root Exp $

*************************************************************/

#include "mem.h"
#include "future.h"

/* this is how maps are structured: */

#define FIRST_PARENT 1
#define NUM_SLOTS    2
#define ANNOTATION   3
#define SLOT_NAME(m,i) AT(m,(4+i))
#define SLOT_VALUE(m,i) AT(m,(AS_INT(AT(m,NUM_SLOTS))+4+i))
#define SLOT_ANNOTATION(m,i) AT(m,(AS_TWICE_INT(AT(m,NUM_SLOTS))+4+i))

/*
 * for now, all annotations point to strings. Note that SLOT_VALUE(m,0)
 * is always the value of the _Size metaslot. As with all values, it
 * is a normal object (an integer, in this case) if the slot is constant
 * and a code object if it is not. This code might just fetch or
 * store a value in the object, in the case of a data slot or an
 * assignment slot, respectively
 */

#ifndef MAPSBODY

extern OOP mapMapCntxt, slotMapCntxt, intMapCntxt, floatMapCntxt,
           vectorMapCntxt, byteVectorMapCntxt, stringMapCntxt;

extern void initMaps ();

extern OOP C2SelfString ( char * s );

#endif
