/****************************************************************

   executes the bytecodes
   $Id: interp.h,v 1.2 1995/11/30 02:02:00 root Exp $
****************************************************************/

/********* normal Self bytecodes *************************
0: extendIndex  - extends the index of the next bytecode with
                  the five bits in this index
1: pushSelf     - puts the value of Self on the stack
2: literal      - puts literalArray[index] on the stack
3: return       - returns to sender with top of stack as result
4: directee     - changes the lookup of the next instruction ( which
                  must be a resend )
5: send         - sends the message literalArray[index] to the object
                  on the top of stack
6: selfSend     - sends the message literalArray[index] to self
7: resend       - sends the message literalArray[index] to self but
                  starts the lookup with the parents
*********************************************************/
 
/********* extended bytecodes *** op = 1 *********************
0: pushSelf     - for compatibility
1: pushPC       - puts the virtual PC on the stack
2: get          - fetches a word with the offset  at the top of the
                  stack in the method holder and places the result
                  on the stack
3: put          - places the word on the next to the top of the stack
                  in the method holder using the offset at the top
                  of the stack
4: drop         - removes the top of stack
5: dup          - makes a copy of the tos
6: swap         - exchanges the tos with next
7: over         - make a copy of next
 
8:  shiftLeft    - multiplies the top of stack by 2**next
9:  shiftRight   - divides the top of stack by 2**next
10: logicalRight - divides the unsigned top of stack by 2**next
11: rotateLeft   - like shiftLeft, but bit 31 goes into bit 0
12: not          - inverts the bit of the top of stack
13: and          - ands the top of stack ( tos ) with the next word on stack
14: or           - ors the tos with next
15: xor          - exclusive-ors tos with next
 
16: addInt       - adds tos with next ( doesn't handle tags )
17: subInt       - subtracts operands
18: multInt      - multiplies operands
19: divInt       - divides operands
20: addFloat     - adds tos with next ( 32 bits, no tags )
21: subFloat     - subtracts operands
22: multFloat    - multiplies operands
23: divFloat     - divides operands
 
24: jmp          - puts the tos in the virtual PC
25: jmpEq        - puts tos in the PC if the next two words are the same
26: jmpLess      - puts tos in the PC if third word is less than next 
27: jmpLower     - puts tos in the PC if third word is less than unsigned next
28: jmpInt       - puts tos in the PC if next is a small integer
29: jmpFloat     - puts tos in the PC if next is a floating point number
30: 
31: 

Note: an overflow in the integer math instructions or an exception
in the floating point math instructions result in the currently
executing context being "poisoned", which may be handled with the
normal exception mechanisms.
******************************************************************/
