#define COMPBODY 1
#include "comp.h"
#include <stdio.h>

static char rcsid[]= "$Id: comp.c,v 1.3 1995/09/12 16:44:56 root Exp $";

void compList(struct expr * list); /* definition below */
void compArgs(struct expr * argList);
void compCode(struct expr * codeList);

void compExpr(struct expr* e)
    {
    struct expr * r;
    
    switch(e->type)
        {
        case method:
        case block:
                      printf ( "%s ::= ( |\n", e->name );
                      compArgs ( e->info.method.slots );
                      printf ( "  |\n" );
                      compCode ( e->info.method.code );
                      printf ( "| )\n" );
        case number:
        case string: 
                      printf ("push %s\n", e->name);
                      break;
        case unary: 
                      if ( (r = e->info.unaryRec)->type == resend )
                          {
                          if (r->flags & SELFSEND ) printf ("selfSend %s\n", e->name);
                          if (r->flags & SIMPLERESEND ) printf ("resend %s\n", e->name);
                          if (r->flags & DIRECTEDRESEND )
                              {
                              printf ("directee %s\n", r->name);
                              printf ("resend %s\n", e->name);
                              }
                          }
                      else
                          {
                          compExpr(e->info.unaryRec);
                          printf ("send %s\n", e->name);
                          }
                      break;
        case binary:
                      compExpr(e->info.bin.arg);
                      if ( (r = e->info.bin.receiver)->type == resend )
                          {
                          if (r->flags & SELFSEND ) printf ("selfSend %s\n", e->name);
                          if (r->flags & SIMPLERESEND ) printf ("resend %s\n", e->name);
                          if (r->flags & DIRECTEDRESEND )
                              {
                              printf ("directee %s\n", r->name);
                              printf ("resend %s\n", e->name);
                              }
                          }
                      else
                          {
                          compExpr(e->info.bin.receiver);
                          printf ("send %s\n", e->name);
                          }
                      break;
        case keyWord: 
                      compList(e->info.key.argList);
                      if ( (r = e->info.key.receiver)->type == resend )
                          {
                          if (r->flags & SELFSEND ) printf ("selfSend %s\n", e->name);
                          if (r->flags & SIMPLERESEND ) printf ("resend %s\n", e->name);
                          if (r->flags & DIRECTEDRESEND )
                              {
                              printf ("directee %s\n", r->name);
                              printf ("resend %s\n", e->name);
                              }
                          }
                      else
                          {
                          compExpr(e->info.key.receiver);
                          printf ("send %s\n", e->name);
                          }
                      break;
        }
    if ( e->flags & NLR ) printf ("return\n");
    }

void compList(struct expr * list)
    {
    if ( list == NULL )
        return;
    compList(list->next);
    compExpr(list);
    }


void compArgs(struct expr * argList)
    {
    if ( argList == NULL )
        return;
    if ( argList->type == annot )
        {
        printf ( "----- %s -----\n", argList->name );
        compArgs ( argList->info.annot.value );
        }
    else
        {
        printf ( "%s := \n", argList->name );
        compExpr ( argList->info.slot.value );
        }
    compArgs ( argList->next );
    }

void compCode(struct expr * codeList)
    {
    if ( codeList == NULL )
        return;
    compExpr ( codeList );
    compCode ( codeList->next );
    }
