/**************************************************************************

   Tiny Self Interpreter - (C) Jecel 23/08/1993
                                     16/06/1994

**************************************************************************/

#include <stdio.h>
#include "lex.h"
#include "parser.h"
#include "scan.h"
#include "comp.h"
#include "interp.h"
#include "cpu.h"
#include "maps.h"
#include "future.h"
#include <string.h>
#include <stdlib.h>

static char rcsid[] = "$Id: ts.c,v 1.4 1995/11/30 02:02:38 root Exp $";


void main ( int argc, char * argv[] )
    {
    struct token * tp;
    struct expr * ex;
    enum lexType tpType;
    char fname [ 80 ];

    initMem();
    initMaps();
    initCPU();
	do {
	   tp = nextToken();
	   tpType = tp->ltype;
	   /* printf("\n%s -> %s", lexTypeString[tp->ltype], tp->str); */
	   if ( tpType != empty && tpType != end )
	       {
	       backToken(tp);
	       ex = getExpr();
	       if ( ex != NULL )
		   compExpr(ex);
	       printf("\n-----%d------------------\n", lastError);
               printf("%s:%d.%d\n", currentName(), currentLine(), currentCol());
               fflush(stdout);
	       while ( (tpType = (tp = nextToken())->ltype ) != empty &&
		       tpType != end )
		   printf("\n*** %s ---> what do I do with this?? ***\n", tp->str );
	       }
	   } while (tpType!=end);
    fprintf(stderr,"\n\n--------------------------\n");
    fprintf(stderr,"Number of Objects            %d\n", pStat.objs);
    fprintf(stderr,"Number of Objects w/Slots    %d\n", pStat.slottedObjs);
    fprintf(stderr,"Number of Data Objects       %d\n", pStat.dataObjs);
    fprintf(stderr,"Number of Traits Objects     %d\n", pStat.traitsObjs);
    fprintf(stderr,"Number of Data Slots         %d\n", pStat.normalSlots);
    fprintf(stderr,"Number of Constant Slots     %d\n", pStat.constSlots);
    fprintf(stderr,"Number of Argument Slots     %d\n", pStat.argSlots);
    fprintf(stderr,"Number of Messages  w/ 0 Arg %d\n", pStat.nargs[0]);
    fprintf(stderr,"Number of Messages  w/ 1 Arg %d\n", pStat.nargs[1]);
    fprintf(stderr,"Number of Messages  w/ 2 Arg %d\n", pStat.nargs[2]);
    fprintf(stderr,"Number of Messages  w/ 3 Arg %d\n", pStat.nargs[3]);
    fprintf(stderr,"Number of Messages  w/ 4 Arg %d\n", pStat.nargs[4]);
    fprintf(stderr,"Number of Messages  w/ 5 Arg %d\n", pStat.nargs[5]);
    fprintf(stderr,"Number of Messages  w/ 6 Arg %d\n", pStat.nargs[6]);
    fprintf(stderr,"Number of Messages  w/ 7 Arg %d\n", pStat.nargs[7]);
    fprintf(stderr,"Number of Messages  w/ 8 Arg %d\n", pStat.nargs[8]);
    fprintf(stderr,"Number of Messages  w/ 9 Arg %d\n", pStat.nargs[9]);
    fprintf(stderr,"Number of Seq. Messages      %d\n", pStat.menSeq);
    fprintf(stderr,"Number of Par. Messages      %d\n", pStat.menPar);
    exit ( 0 );
    }
