/**************************************************************************

  Tiny Self Character Reader - (C) Jecel 20/08/1993

**************************************************************************/

#define SCAN_BODY
#include "scan.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

static char rcsid[] = "$Id: scan.c,v 1.4 1995/11/30 02:02:36 root Exp $";

char lstc = '\0', lstc2 = '\0';
#define STSIZE   100
int fstkp = 0;
struct {
       FILE * fp;
       char name[80];
       int line, col;
       } fstk [STSIZE] =   /* _RunScript nesting  */
       { { (FILE *) NULL,
         "<stdin>",
         0, 0 } };

char * currentName ()
    {
    return ( fstk [ fstkp ].name ) ;
    }

int currentLine ()
    {
    return ( fstk [ fstkp ].line ) ;
    }

int currentCol ()
    {
    return ( fstk [ fstkp ].col );
    }

int stdinDone = 0;

char nextChar ()
    {
    int c;

    if ( stdinDone ) return ( '\0' );
    if ( lstc != '\0' )
	{
	c = lstc;
	lstc = lstc2;
	lstc2 = '\0';
	}
      else { if ( fstkp == 0 )
	{
	while ((c = getchar ()) != EOF && c == '\0' );
	if ( c == EOF )
            {
            c = '\0';
            stdinDone = -1;
            }
	}
      else
	{
	while ((c = getc (fstk[fstkp].fp)) != EOF && c == '\0' );
	if ( c == EOF )
	    {
	    fclose (fstk[fstkp--].fp);/* if this file is ended - back up ... */
	    c = nextChar(); /* ... and try again */
            return ( (char) c );
	    }
	}
    if ( c == '\n' )
        {
        ++ fstk [ fstkp ].line;
        fstk [ fstkp ].col = 0;
        }
      else
       ++ fstk [ fstkp ].col; }
    return ( (char) c );
    }

void backChar ( char c )
    {

    if ( lstc2 == '\0' )
	{
	lstc2 = lstc;
	lstc = c;
	}
      else
	{
	fprintf (stderr, "\n** back char called three times **\n" );
	exit (-1);
	}
    }

void pushFile ( char * fname )
    {

    fstk [ ++fstkp ].fp = fopen ( fname, "r" );
    if ( fstk [ fstkp ].fp == NULL )
	{
	fprintf (stderr, "\n** cannot open %s **\n", fname);
	exit ( -1 );
	}
    sprintf ( fstk [ fstkp ].name, "[%d]%s", fstkp, fname );
    fstk [ fstkp ].line = 0;
    fstk [ fstkp ].col = 0;
    }
