/************************************************************************

  Definitions for the syntatical analysis of Tiny Self
  (C) Jecel 23/08/93
  $Id: parser.h,v 1.5 1995/11/30 02:02:35 root Exp $

************************************************************************/


  /********************** SYNTAX OVERVIEW ***********************

   expression = keyMess

   keyMess    = n:binMess - kMess(n)
			  - TRUE^n
		resend kMess(self)

   kMess(n)   = smallKey argList(n)

   argList(n) = keyMess - capKey argList(n)
			- TRUE^n

   binMess    = n:unaryMess bList(n)
		resend n:bMess(self) bList(n)

   bList(n)   = x:bMess(n) bList(x)
		TRUE^n

   bMess(n)   = operator - unaryMess
			 - keyMess -- added

   unaryMess  = n:primary - uMess(n)
			    TRUE^n
		resend uMess(self)

   uMess(n)   = a:identifier - uMess(a(n))
			     - TRUE

   resend     = "resend." nowhite
		identifier "." nowhite
		TRUE

   primary    = -- "self"
		number
		string
		method
		block
		annotation

   method     = "(" slotList code ")"

   block      = "[" slotList code "]"

   annotation = "{" string primary "}"

   code       = "^" expression - "."
			       - TRUE
		expression - "." code
			   - TRUE
		TRUE

   slotList   = "|" sList
		TRUE

   sList      = "|"
		annotSlots sList
		slot - "." sList
		     - "|"

   annotSlots = "{" string annotList
                "{" "}" "=" string - "."    -- 4.0 patch
                                   - TRUE

   annotList  = "}"
		annotSlots annotList
		slot - "." annotList
		     - "}"

   slot       = privacy - argSlot
			- dataSlot
			- bSlot
			- kSlot

   privacy    = "^"
		"_"
		"^_"
		"_^"
		"!" -- VM slots added
		TRUE

   argSlot    = ":" slotName -- ":" identifier -- parent args added

   dataSlot   = slotName - "<-" expression
			 - "=" expression
			 - TRUE

   bSlot      = operator - "=" method
			 - identifier "=" method

   kslot      = smallKeyword - identifier ceL "=" method
			     - cL "=" method

   cL         = capKeyword cL
		TRUE

   ceL        = capKeyword identifier ceL
		TRUE

   slotName   = identifier priority

   priority   = "*" priority
		TRUE

   **************************************************************/

enum syntaxError { none, unexpectedEOI, other };

enum exprType { number, string, method, block, slot, resend,
		unary, binary, keyWord, annot };

struct expr {
    enum exprType type;
    int flags;
    char * name;
    struct expr * next;
    union {
	struct {
	    struct expr * receiver, * argList;
	    } key;
	struct {
	    struct expr * receiver, * arg;
	    } bin;
	struct expr * unaryRec;
	struct {
	    struct expr * value;
	    } slot;
	struct {
	    struct expr * slots, * code;
	    } method;
	struct {
	    struct expr * value;
	    } annot;
	} info;
    } ;

/*** some flags ****/
#define SELFSEND       1
#define SIMPLERESEND   2
#define DIRECTEDRESEND 4
#define NLR            8
#define SPRV(x)        ((x)<<4)
#define APRV(x)        ((x)<<6)
  #define UNDECLARED   0
  #define PUBLIC       1
  #define PRIVATE      2
  #define VM           3
#define ASSIGNABLE     256
#define ARGUMENT       512
#define PPRI(x)        ((x)<<10)

struct parseStats
    {
    int objs,
	slottedObjs,
	dataObjs,
	traitsObjs,
	normalSlots,
	constSlots,
	argSlots,
	nargs[10],
	menSeq,
	menPar;
    } ;

#ifndef PARSER_BODY

extern enum syntaxError lastError;

extern struct expr * getExpr();
extern void printExpr(struct expr * ex);

extern * exprStr[];

extern struct parseStats pStat;

#else

enum syntaxError lastError;

char * exprStr[] = { "number", "string", "method", "block", "slot", "resend",
		"unary", "binary", "keyWord", "annotation" };

struct parseStats pStat = {0,
			   0,
			   0,
			   0,
			   0,
			   0,
			   0,
			   {0,0,0,0,0,0,0,0,0,0},
			   0,
			   0
			   };

#endif
