/**********************************************************

   Tiny Self memory subsystem (c) 1994 Jecel Assumpcao Jr
   $Id: mem.h,v 1.4 1995/11/30 02:02:09 root Exp $

**********************************************************/

#ifndef MEM_HEADER

#define MEM_HEADER 1

#define TAG_MASK   3
#define INT_TAG    0
#define OOP_TAG    1
#define FLOAT_TAG  2
#define FUTURE_TAG 3

typedef char * OOP;
        /*
         * it actually should be a pointer to an OOP, but
         * it is declared as a char pointer so the tag
         * can be added to it
         */
#define PENDING    0
        /*
         * all objects start with a field pointing to the
         * pending messages queue. If the queue is empty,
         * then the field points to the context of this
         * object's map
         */
#define AS_PTR(obj) (obj-OOP_TAG)
#define PTR_AS_OOP(p) (((oop)p)+OOP_TAG)

#define AT(obj,field) (((oop *) AS_PTR(obj))[field])
        /* index into the object, but first remove the tag */

#define AS_INT(obj) (obj>>2)
#define AS_TWICE_INT(obj) (obj>>1)
        /* it is a good idea to check the tag before using these */
#define INT_AS_OOP(num) (num<<2)

#ifndef MEM_BODY

extern void initMem ();
extern OOP clone ( OOP old );
extern OOP cloneGrowing ( OOP old, int slots );

extern OOP lobby;
extern OOP emptyObj;

#else

#include "gc.h"

#endif

#endif
