/**********************************************************

   Tiny Self memory subsystem (c) 1994 Jecel Assumpcao Jr

**********************************************************/

#define MEM_BODY   1
#include "mem.h"

static char rcsid[] = "$Id: mem.c,v 1.5 1995/11/30 02:02:08 root Exp $";

#define K   1024

OOP lobby;
OOP emptyObj;

/***************** explicit GC not used initially ************

#define EdenSize   200*K
#define SurvSize   200*K
#define OldSize    5*K*K

char eden [ EdenSize ],
     survEven [ SurvSize ],
     survOdd  [ SurvSize ],
     old      [ OldSize ];

char * edenStart     = & eden [ 0 ],
     * edenEnd       = & eden [ EdenSize ],
     * survEvenStart = & survEven [ 0 ],
     * survEvenEnd   = & survEven [ SurvSize ],
     * survOddStart  = & survOdd [ 0 ],
     * survOddEnd    = & survOdd [ SurvSize ],
     * oldStart      = & old [ 0 ],
     * oldEnd        = & old [ OldSize ];

char * eden1, * eden2,
     * survEven1, * survEven2,
     * survOdd1, * survOdd2,
     * old1, * old2;

*************** end of explict GC definitions **************/

void initMem ()
    {

/************ no need to initialize explicit GC yet *********
    eden1 = edenStart;
    eden2 = edenEnd;
    survEven1 = survEvenStart;
    survEven2 = survEvenEnd;
    survOdd1 = survOddStart;
    survOdd2 = survOddEnd;
    old1 = oldStart;
    old2 = oldEnd;
************* end of initialization of explicit GC **********/

    GC_register_displacement ( OOP_TAG );    /* take tags into account */
    GC_register_displacement ( FUTURE_TAG ); /* take futures into account */

         /* note: the two lines above are NOPS if interior
          *       pointers are enabled in the gc ( the default )
          *       but it is better to be safe than sorry...
          */
    }

OOP clone ( OOP old )
    {
    }

OOP cloneGrowing ( OOP old, int slots )
    {
    }

