/*************************************************************

   These objects are used in three distinct roles in the
   system:

       future - this is the initial result of any message
                send. Any attempt to send a message to a
                future will block the sender and store it
                in the future's waiting queue, unless an
                answer has already been returned to the
                future, in which case the message is
                forwarded to this answer.
       message - holds all of the information relevant to
                 a message send and can be placed in an
                 object's receive queue.
       context - holds all of the information relevant to
                 an executing method and can be placed in
                 the scheduler's ready queue or in a
                 future's waiting queue.

                    $Id: future.h,v 1.1 1995/11/30 02:01:56 root Exp $

*************************************************************/

#include "mem.h"

/*  here are what futures look like (based on ARM calling convention):  */

#define NEXT_PENDING   1
#define NEXT_QUEUE     2
#define BLOCKED_ON     3
#define WAITING_FOR    4
#define REPLY_FREES    5
#define VIRTUAL_PC     6
#define VIRTUAL_SP     7
#define MY_META        8
#define MY_SELF        9
#define MY_ARG0       10 
#define MY_ARG1       11
#define MY_ARG2       12
#define OUT_SELF      13
#define OUT_ARG0      14
#define OUT_ARG1      15
#define OUT_ARG2      16
#define TEMP5         OUT_ARG0
#define TEMP4         OUT_ARG1
#define TEMP3         OUT_ARG2
#define TEMP2         17
#define TEMP1         18
#define TEMP0         19
#define LITERALS      20
#define STACK_START   21
#define STACK_LIMIT   31
    /*
     * the STACK_LIMIT is not a hard limit - if the stack needs more
     * the 10 words, it can be extended in 28 word increments as needed.
     * This is not efficient, but should be rarely used.
     * Here is what a stack extension looks like:
     */
#define NEXT_STACK     1
#define PREV_STACK     2
#define THIS_SP        3
#define THIS_START     4
    /*
     * Both futures and stack extensions are 128 bytes long, and are
     * allocated from a common area in memory. When there are stack
     * extensions, then MY_SP contains a pointer to the current
     * extensions rather than an integer, as is normally the case.
     * The current extension's THIS_SP contains an integer to indicate
     * the top of stack (always between 4 and 31)
     */

#ifndef FUTUREBODY


#endif
